/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Sun Microsystems code.
 *
 * The Initial Developer of the Original Code is Sun Microsystems.
 * Portions created by the Initial Developer are Copyright (C) 2007
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Michael Buettner <michael.buettner@sun.com>
 *   Philipp Kewisch <mozilla@kewis.ch>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * Global variables
 */
var gCustomizeId;

/**
 * the current mode is set to a string defining the current
 * mode we're in. allowed values are:
 *  - 'mode'
 *  - 'mail'
 *  - 'calendar'
 *  - 'task'
 */
var gCurrentMode = 'mail';

/**
 * Helper function to get the view deck in a neutral way, regardless of whether
 * we're in Thunderbird or SeaMonkey
 */
function getMailBar() {
  // Not used in Spicebird
}

/**
 * Ensure that switching to the messenger window also switches to mail mode.
 * We probably should also catch this from other windows (compose, addressbook),
 * but for now we'll keep it here. This function overrides the toMessengerWindow
 * function in /mail/base/content/mailCore.js.
 *
 * Prasad: This function makes sure that when we try to switch to the
 *         main window from addressbook or compose window, the current application
 *         is switched to mailnews.  Should see if Spicebird needs an equivalent
 *         to this function
 *
var toMessengerWindow = function ltnToMessengerWindow() {
    var wm = Components.classes['@mozilla.org/appshell/window-mediator;1']
             .getService(Components.interfaces.nsIWindowMediator);

    var topWindow = wm.getMostRecentWindow("mail:3pane");

    if (topWindow) {
        var tomail = topWindow.document.getElementById("switch2mail");
        tomail.doCommand();
        topWindow.focus();
    } else {
        window.open("chrome://messenger/content/messenger.xul",
                    "_blank",
                    "chrome,extrachrome,menubar,resizable,scrollbars,status,toolbar");
    }
};
 */

/**
 * ltnSwitch2Mail() switches to the mail mode
 */

function ltnSwitch2Mail() {
  if (gCurrentMode != 'mail') {
    // For Spicebird
    //   we only set the mode. Nothing else!
    gCurrentMode = 'mail';

    window.setCursor("auto");
  }
}

/**
 * ltnSwitch2Calendar() switches to the calendar mode
 */

function ltnSwitch2Calendar() {
  if (gCurrentMode != 'calendar') {
    // For Spicebird
    //   we only set the mode
    gCurrentMode = 'calendar';
    window.setCursor("auto");
  }
}

/**
 * ltnSwitch2Task() switches to the task mode
 */

function ltnSwitch2Task() {
  if (gCurrentMode != 'task') {
    // For Spicebird
    //   we only set the mode. Nothing else!
    gCurrentMode = 'task';
    window.setCursor("auto");
  }
}

function CustomizeApplicationToolbar(id) {
  // Not used in Spicebird
}

function ModeToolboxCustomizeDone(aToolboxChanged) {
  // Not used in Spicebird
}

function EnableDisableHierarchy(item, disable) {
  // Not used in Spicebird
}

function EnableHierarchy(item) {
  // Not used in Spicebird
}
