/*****************************************************************************
 * theme_support.h
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2007 Greg Hosler
 * ghosler ['at'] users.sourceforge.net
 *****************************************************************************/

#ifndef _THEME_SUPPORT_H
#define _THEME_SUPPORT_H

#define GYACHI_BOLD			"gyachi-bold"
#define GYACHI_BUDDY_AWAY		"gyachi-buddy_away"
#define GYACHI_BUDDY_IDLE		"gyachi-buddy_idle"
#define GYACHI_BUDDY_OFFLINE		"gyachi-buddy_offline"
#define GYACHI_BUDDY_ONLINE		"gyachi-buddy_online"
#define GYACHI_CHAT			"gyachi-chat"
#define GYACHI_COLORS			"gyachi-colors"
#define GYACHI_GAMES			"gyachi-games"
#define GYACHI_ICON			"gyachi-gyach_icon"
#define GYACHI_ITALIC			"gyachi-italic"
#define GYACHI_LAUNCHCAST		"gyachi-launchcast"
#define GYACHI_LOGIN_LOGO		"gyachi-login_logo"
#define GYACHI_MAIL			"gyachi-mail"
#define GYACHI_NO_PHOTO			"gyachi-no_photo"
#define GYACHI_PM_AUDIBLE		"gyachi-pm_audible"
#define GYACHI_PM_BUZZ			"gyachi-pm_buzz"
#define GYACHI_PM_FILE			"gyachi-pm_file"
#define GYACHI_PM_IGNORE		"gyachi-pm_ignore"
#define GYACHI_PM_JOIN			"gyachi-pm_join"
#define GYACHI_PM_PROFILE		"gyachi-pm_profile"
#define GYACHI_PM_TUX			"gyachi-pm_tux"
#define GYACHI_PM_VOICE			"gyachi-pm_voice"
#define GYACHI_VOICE_LOGO		"gyachi-voice_logo"
#define GYACHI_VOICE_OFF		"gyachi-voice_off"
#define GYACHI_VOICE_ON			"gyachi-voice_on"
#define GYACHI_VOICE_TALK		"gyachi-voice_talk"
#define GYACHI_PHOTOSHARE		"gyachi-photoshare"
#define GYACHI_SMS			"gyachi-sms"
#define GYACHI_STATUS_AWAY		"gyachi-status_away"
#define GYACHI_STATUS_CAM_FEMALE	"gyachi-status_cam_female"
#define GYACHI_STATUS_CAM_MALE		"gyachi-status_cam_male"
#define GYACHI_STATUS_CAM		"gyachi-status_cam"
#define GYACHI_STATUS_HERE_FEMALE	"gyachi-status_here_female"
#define GYACHI_STATUS_HERE_MALE		"gyachi-status_here_male"
#define GYACHI_STATUS_HERE		"gyachi-status_here"
#define GYACHI_STATUS_IGNORE		"gyachi-status_ignore"
#define GYACHI_STATUS_MUTE		"gyachi-status_mute"
#define GYACHI_STEALTH_OFF		"gyachi-stealth_off"
#define GYACHI_STEALTH_ON		"gyachi-stealth_on"
#define GYACHI_UNDERLINE		"gyachi-underline"
#define GYACHI_WEBCAM			"gyachi-webcam"

#ifdef OBSOLETED
#define GYACHI_PM_CLOSE			"gyachi-pm_close"
#define GYACHI_PM_ENCRYPT		"gyachi-pm_encrypt"
#define GYACHI_PM_ERASE			"gyachi-pm_erase"
#define GYACHI_PM_SAVE			"gyachi-pm_save"
#define GYACHI_PM_SEND			"gyachi-pm_send"

#define GYACHI_PYVOICE_IGNORE		"gyachi-pyvoice_ignore"
#define GYACHI_PYVOICE_INFO		"gyachi-pyvoice_info"

#define GYACHI_STATUS_IDLE		"gyachi-status_idle"
#endif

#ifdef ICON_FACTORY
typedef struct gyachi_icon_def {
	char *stock_id;
	char *filename;
} GYACHI_ICON_DEF;

GYACHI_ICON_DEF gyachi_icons[] = {
{ "gyachi-bold",		"bold" },
{ "gyachi-buddy_away",		"buddy_away" },
{ "gyachi-buddy_idle",		"buddy_idle" },
{ "gyachi-buddy_offline",	"buddy_offline" },
{ "gyachi-buddy_online",	"buddy_online" },
{ "gyachi-chat",		"chat" },
{ "gyachi-colors",		"colors" },
{ "gyachi-games",		"games" },
{ "gyachi-gyach_icon",		"gyach_icon" },
{ "gyachi-italic",		"italic" },
{ "gyachi-launchcast",		"launchcast" },
{ "gyachi-login_logo",		"login_logo" },
{ "gyachi-mail",		"mail" },
{ "gyachi-no_photo",		"no_photo" },
{ "gyachi-pm_audible",		"pm_audible" },
{ "gyachi-pm_buzz",		"pm_buzz" },
{ "gyachi-pm_file",		"pm_file" },
{ "gyachi-pm_ignore",		"pm_ignore" },
{ "gyachi-pm_join",		"pm_join" },
{ "gyachi-pm_profile",		"pm_profile" },
{ "gyachi-pm_tux",		"pm_tux" },
{ "gyachi-pm_voice",		"pm_voice" },
{ "gyachi-sms",			"sms" },
{ "gyachi-status_away",		"status_away" },
{ "gyachi-status_cam_female",	"status_cam_female" },
{ "gyachi-status_cam_male",	"status_cam_male" },
{ "gyachi-status_cam",		"status_cam" },
{ "gyachi-status_here_female",	"status_here_female" },
{ "gyachi-status_here_male",	"status_here_male" },
{ "gyachi-status_here",		"status_here" },
{ "gyachi-status_ignore",	"status_ignore" },
{ "gyachi-status_mute",		"status_mute" },
{ "gyachi-stealth_off",		"stealth_off" },
{ "gyachi-stealth_on",		"stealth_on" },
{ "gyachi-underline",		"underline" },
{ "gyachi-voice_logo",		"voice_logo" },
{ "gyachi-voice_off",		"voice_off" },
{ "gyachi-voice_on",		"voice_on" },
{ "gyachi-voice_talk",		"voice_talk" },
{ "gyachi-photoshare",		"photoshare" },
{ "gyachi-webcam",		"webcam" },
#ifdef OBSOLETED
{ "gyachi-pm_close",		"pm_close" },
{ "gyachi-pm_encrypt",		"pm_encrypt" },
{ "gyachi-pm_erase",		"pm_erase" },
{ "gyachi-pm_save",		"pm_save" },
{ "gyachi-pm_send",		"pm_send" },
{ "gyachi-pyvoice_ignore",	"pyvoice_ignore" },
{ "gyachi-pyvoice_info",	"pyvoice_info" },
{ "gyachi-status_idle",		"status_idle" },
#endif
{ 0,				0 }
};
#endif

extern GtkIconSize GYACHI_ICON_SIZE_MAIL;
extern GtkIconSize GYACHI_ICON_SIZE_LOGO;
extern GtkIconSize GYACHI_ICON_SIZE_VLOGO;
extern GtkIconSize GYACHI_ICON_SIZE_SMS;
extern GtkIconSize GYACHI_ICON_SIZE_LCAST;
extern GtkIconSize GYACHI_ICON_SIZE_PHOTO;

extern void load_gyachi_theme(char *theme);
extern GList *gyachi_themes_available();
extern void free_gyachi_theme_list(GList *themes);
extern GdkPixbuf *get_pixbuf_from_stock_id(GtkWidget *w, const char *stock_id, GtkIconSize icon_size);

#endif

